<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('contracts', function (Blueprint $table) {
        $table->id();
        // --- Columnas de datos ---
        $table->foreignId('employee_id')->constrained('users');
        $table->foreignId('contract_type_id')->constrained('contract_types'); 
        $table->date('start_date');
        $table->date('end_date')->nullable();
        $table->decimal('salary', 10, 2);
        
        
        $table->timestamps(); 
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contracts');
    }
};
