<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('timesheets', function (Blueprint $table) {
        $table->id();

        $table->foreignId('employee_id')->constrained('users')->onDelete('cascade');

        $table->date('date'); 
        $table->decimal('hours_worked', 5, 2); 
        $table->string('status')->default('pendiente'); 
        $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('timesheets');
    }
};
