<?php if($paginator->hasPages()): ?>
   
    <nav role="navigation" aria-label="Pagination Navigation" class="flex items-center justify-center space-x-3">
        
        
        <?php if($paginator->onFirstPage()): ?>
            
            <span class="flex items-center justify-center w-8 h-8 rounded-full text-gray-400 cursor-not-allowed">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" /></svg>
            </span>
        <?php else: ?>
            <a href="<?php echo e($paginator->previousPageUrl()); ?>" rel="prev" class="flex items-center justify-center w-8 h-8 rounded-full text-gray-800 hover:bg-gray-100">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" /></svg>
            </a>
        <?php endif; ?>

        
        <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            
            
            <?php if(is_string($element)): ?>
                <span class="flex items-center justify-center w-8 h-8 text-gray-500"><?php echo e($element); ?></span>
            <?php endif; ?>

            
            <?php if(is_array($element)): ?>
                <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($page == $paginator->currentPage()): ?>
                        
                        <span class="flex items-center justify-center w-8 h-8 rounded-full bg-primary-600 text-white font-bold"><?php echo e($page); ?></span>
                    <?php else: ?>
                        
                        <a href="<?php echo e($url); ?>" class="flex items-center justify-center w-8 h-8 rounded-full text-gray-800 hover:bg-gray-100"><?php echo e($page); ?></a>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        
        <?php if($paginator->hasMorePages()): ?>
            <a href="<?php echo e($paginator->nextPageUrl()); ?>" rel="next" class="flex items-center justify-center w-8 h-8 rounded-full text-gray-800 hover:bg-gray-100">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" /></svg>
            </a>
        <?php else: ?>
            
            <span class="flex items-center justify-center w-8 h-8 rounded-full text-gray-400 cursor-not-allowed">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" /></svg>
            </span>
        <?php endif; ?>
    </nav>
<?php endif; ?><?php /**PATH C:\xampp\htdocs\system_rrhh\resources\views/vendor/pagination/tailwind.blade.php ENDPATH**/ ?>